/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.lockmgr;

import com.ibm.hsc.common.exceptions.FspLockException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.HscIdUtils;
import com.ibm.hsc.common.util.HscResourceId;
import com.ibm.hsc.fsp.cmdhelpers.FspLockRecord;
import com.ibm.hsc.fsp.lockmgr.FspLockMgr;
import com.ibm.hsc.fsp.lockmgr.FspLockRequest;
import com.ibm.hsc.fsp.lockmgr.FspReqRecord;
import com.ibm.hsc.rep.RException;
import com.ibm.hsc.rep.RObjectId;
import java.util.Vector;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt32;

public class FspLockHelper {
    public int DEFAULT_RETRY_INTERVAL = 10;
    public int DEFAULT_RETRY_TIMES = 5;
    public int ASYNC_RETRY_INTERVAL = 10;
    public int ASYNC_RETRY_TIMES = -1;
    private FspLockMgr mLockMgr;
    private int mLockType;
    private static HscIdUtils mIdUtil = HscIdUtils.getInstance();
    private Vector mReqRecs = new Vector();
    private UnsignedInt32 mReqId;
    private boolean mLocked = false;
    private int mCecLockType = -1;
    private FspReqRecord mCecLock = null;

    public FspLockHelper(FspLockMgr fspLockMgr, int n) {
        this.mLockMgr = fspLockMgr;
        this.mLockType = n;
    }

    private void addReqRecord(CIMObjectPath cIMObjectPath, int n, int n2, boolean bl) {
        if (this.mLockMgr.getSupportMultiHMC() || n2 == 128 || n2 == 192 || bl) {
            HscResourceId hscResourceId = mIdUtil.createHscResourceId(cIMObjectPath, n);
            FspReqRecord fspReqRecord = new FspReqRecord(hscResourceId, n2);
            this.mReqRecs.addElement(fspReqRecord);
        }
    }

    private void addReqRecord(RObjectId rObjectId, int n, int n2, boolean bl) throws RException {
        if (this.mLockMgr.getSupportMultiHMC() || n2 == 128 || n2 == 192 || bl) {
            HscResourceId hscResourceId = mIdUtil.createHscResourceId(rObjectId, n);
            FspReqRecord fspReqRecord = new FspReqRecord(hscResourceId, n2);
            this.mReqRecs.addElement(fspReqRecord);
        }
    }

    public UnsignedInt32 lock() throws PIHscServerException {
        return this.lock(this.DEFAULT_RETRY_INTERVAL, this.DEFAULT_RETRY_TIMES);
    }

    public UnsignedInt32 lockAsync() throws PIHscServerException {
        return this.lockWait(this.ASYNC_RETRY_INTERVAL);
    }

    public UnsignedInt32 lockWait(int n) throws PIHscServerException {
        return this.lock(n, this.ASYNC_RETRY_TIMES);
    }

    public UnsignedInt32 lock(int n, int n2) throws PIHscServerException {
        if (this.mReqRecs.size() > 0) {
            this.mReqId = this.mLockMgr.lock(this.mReqRecs, n, n2);
            if (this.mReqId != null) {
                this.mLocked = true;
            }
            return this.mReqId;
        }
        return new UnsignedInt32(-1L);
    }

    public void unlockClientReq(UnsignedInt32 unsignedInt32) throws PIHscServerException {
        if (unsignedInt32.intValue() != -1) {
            this.mLockMgr.unlock(unsignedInt32);
        }
    }

    public void unlock() throws PIHscServerException {
        if (this.mLocked) {
            this.mLockMgr.unlock(this.mReqId);
            this.mLocked = false;
        }
    }

    public void addCecLock(CIMObjectPath cIMObjectPath) {
        this.addCecLock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecLock(RObjectId rObjectId) throws RException {
        this.addCecLock(rObjectId, this.mLockType, false);
    }

    public void addCecLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 0, n, bl);
        if (this.mLockMgr.getSupportMultiHMC() || n == 128 || n == 192 || bl) {
            this.mCecLockType = n;
            this.mCecLock = (FspReqRecord)this.mReqRecs.elementAt(this.mReqRecs.size() - 1);
        } else {
            this.mCecLockType = 64;
        }
    }

    public void addCecLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 0, n, bl);
        if (this.mLockMgr.getSupportMultiHMC() || n == 128 || n == 192 || bl) {
            this.mCecLockType = n;
            this.mCecLock = (FspReqRecord)this.mReqRecs.elementAt(this.mReqRecs.size() - 1);
        } else {
            this.mCecLockType = 64;
        }
    }

    public void upgradeCecLock() throws PIHscServerException {
        this.upgradeCecLock(this.DEFAULT_RETRY_INTERVAL, this.DEFAULT_RETRY_TIMES);
    }

    public void upgradeCecLock(int n, int n2) throws PIHscServerException {
        if (this.mCecLockType == 64) {
            return;
        }
        if (this.mCecLockType != 0) {
            throw new PIHscServerException("026D", new String[]{"" + this.mCecLockType}, null);
        }
        this.unlock();
        this.mCecLock.setLockType(64);
        this.lock();
    }

    public int getCecLockType() {
        return this.mCecLockType;
    }

    public void addNvramLock(CIMObjectPath cIMObjectPath) {
        this.addNvramLock(cIMObjectPath, this.mLockType, false);
    }

    public void addNvramLock(RObjectId rObjectId) throws RException {
        this.addNvramLock(rObjectId, this.mLockType, false);
    }

    public void addNvramLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 1, n, bl);
    }

    public void addNvramLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 1, n, bl);
    }

    public void addProcLock(CIMObjectPath cIMObjectPath) {
        this.addProcLock(cIMObjectPath, this.mLockType, false);
    }

    public void addProcLock(RObjectId rObjectId) throws RException {
        this.addProcLock(rObjectId, this.mLockType, false);
    }

    public void addProcLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 2, n, bl);
    }

    public void addProcLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 2, n, bl);
    }

    public void addMemLock(CIMObjectPath cIMObjectPath) {
        this.addMemLock(cIMObjectPath, this.mLockType, false);
    }

    public void addMemLock(RObjectId rObjectId) throws RException {
        this.addMemLock(rObjectId, this.mLockType, false);
    }

    public void addMemLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 3, n, bl);
    }

    public void addMemLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 3, n, bl);
    }

    public void addAllLparLock(CIMObjectPath cIMObjectPath) {
        this.addAllLparLock(cIMObjectPath, this.mLockType, false);
    }

    public void addAllLparLock(RObjectId rObjectId) throws RException {
        this.addAllLparLock(rObjectId, this.mLockType, false);
    }

    public void addAllLparLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 6, n, bl);
    }

    public void addAllLparLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 6, n, bl);
    }

    public void addAllSlotLock(CIMObjectPath cIMObjectPath) {
        this.addAllSlotLock(cIMObjectPath, this.mLockType, false);
    }

    public void addAllSlotLock(RObjectId rObjectId) throws RException {
        this.addAllSlotLock(rObjectId, this.mLockType, false);
    }

    public void addAllSlotLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 7, n, bl);
    }

    public void addAllSlotLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 7, n, bl);
    }

    public void addAllSmaLock(CIMObjectPath cIMObjectPath) {
        this.addAllSmaLock(cIMObjectPath, this.mLockType, false);
    }

    public void addAllSmaLock(RObjectId rObjectId) throws RException {
        this.addAllSmaLock(rObjectId, this.mLockType, false);
    }

    public void addAllSmaLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 10, n, bl);
    }

    public void addAllSmaLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 10, n, bl);
    }

    public void addCecUserNameLock(CIMObjectPath cIMObjectPath) {
        this.addCecUserNameLock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecUserNameLock(RObjectId rObjectId) throws RException {
        this.addCecUserNameLock(rObjectId, this.mLockType, false);
    }

    public void addCecUserNameLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 8, n, bl);
    }

    public void addCecUserNameLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 8, n, bl);
    }

    public void addPrimaryFspLock(CIMObjectPath cIMObjectPath) {
        this.addPrimaryFspLock(cIMObjectPath, this.mLockType, false);
    }

    public void addPrimaryFspLock(RObjectId rObjectId) throws RException {
        this.addPrimaryFspLock(rObjectId, this.mLockType, false);
    }

    public void addPrimaryFspLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 4, n, bl);
    }

    public void addPrimaryFspLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 4, n, bl);
    }

    public void addSecondaryFspLock(CIMObjectPath cIMObjectPath) {
        this.addSecondaryFspLock(cIMObjectPath, this.mLockType, false);
    }

    public void addSecondaryFspLock(RObjectId rObjectId) throws RException {
        this.addSecondaryFspLock(rObjectId, this.mLockType, false);
    }

    public void addSecondaryFspLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 5, n, bl);
    }

    public void addSecondaryFspLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 5, n, bl);
    }

    public void addIoSlotLock(CIMObjectPath cIMObjectPath) {
        this.addIoSlotLock(cIMObjectPath, this.mLockType, false);
    }

    public void addIoSlotLock(RObjectId rObjectId) throws RException {
        this.addIoSlotLock(rObjectId, this.mLockType, false);
    }

    public void addIoSlotLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 0, n, bl);
    }

    public void addIoSlotLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 0, n, bl);
    }

    public void addSmaAdapterLock(CIMObjectPath cIMObjectPath) {
        this.addSmaAdapterLock(cIMObjectPath, this.mLockType, false);
    }

    public void addSmaAdapterLock(RObjectId rObjectId) throws RException {
        this.addSmaAdapterLock(rObjectId, this.mLockType, false);
    }

    public void addSmaAdapterLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 0, n, bl);
    }

    public void addSmaAdapterLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 0, n, bl);
    }

    public void addLparLock(CIMObjectPath cIMObjectPath) {
        this.addLparLock(cIMObjectPath, this.mLockType, false);
    }

    public void addLparLock(RObjectId rObjectId) throws RException {
        this.addLparLock(rObjectId, this.mLockType, false);
    }

    public void addLparLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 0, n, bl);
    }

    public void addLparLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 0, n, bl);
    }

    public void addAllVspLock(CIMObjectPath cIMObjectPath) {
        this.addAllVspLock(cIMObjectPath, this.mLockType, false);
    }

    public void addAllVspLock(RObjectId rObjectId) throws RException {
        this.addAllVspLock(rObjectId, this.mLockType, false);
    }

    public void addAllVspLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 9, n, bl);
    }

    public void addAllVspLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 9, n, bl);
    }

    public void addVspLock(CIMObjectPath cIMObjectPath) {
        this.addVspLock(cIMObjectPath, this.mLockType, false);
    }

    public void addVspLock(RObjectId rObjectId) throws RException {
        this.addVspLock(rObjectId, this.mLockType, false);
    }

    public void addVspLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 0, n, bl);
    }

    public void addVspLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 0, n, bl);
    }

    public void addCecCoDCodeLock(CIMObjectPath cIMObjectPath) {
        this.addCecCoDCodeLock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecCoDCodeLock(RObjectId rObjectId) throws RException {
        this.addCecCoDCodeLock(rObjectId, this.mLockType, false);
    }

    public void addCecCoDCodeLock(CIMObjectPath cIMObjectPath, int n, boolean bl) {
        this.addReqRecord(cIMObjectPath, 11, n, bl);
    }

    public void addCecCoDCodeLock(RObjectId rObjectId, int n, boolean bl) throws RException {
        this.addReqRecord(rObjectId, 11, n, bl);
    }

    public void addCecPALock(CIMObjectPath cIMObjectPath) throws PIHscServerException {
        this.genFspLockException(false);
        this.addCecPALock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecPALock(RObjectId rObjectId) throws RException, PIHscServerException {
        this.genFspLockException(false);
        this.addCecPALock(rObjectId, this.mLockType, false);
    }

    public void addCecPALock(CIMObjectPath cIMObjectPath, int n, boolean bl) throws PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(cIMObjectPath, 12, n, bl);
    }

    public void addCecPALock(RObjectId rObjectId, int n, boolean bl) throws RException, PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(rObjectId, 12, n, bl);
    }

    public void addCecDumpLock(CIMObjectPath cIMObjectPath) throws PIHscServerException {
        this.genFspLockException(false);
        this.addCecDumpLock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecDumpLock(RObjectId rObjectId) throws RException, PIHscServerException {
        this.genFspLockException(false);
        this.addCecDumpLock(rObjectId, this.mLockType, false);
    }

    public void addCecDumpLock(CIMObjectPath cIMObjectPath, int n, boolean bl) throws PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(cIMObjectPath, 13, n, bl);
    }

    public void addCecDumpLock(RObjectId rObjectId, int n, boolean bl) throws RException, PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(rObjectId, 13, n, bl);
    }

    public void addCecBpcIpPushLock(CIMObjectPath cIMObjectPath) throws PIHscServerException {
        this.genFspLockException(false);
        this.addCecBpcIpPushLock(cIMObjectPath, this.mLockType, false);
    }

    public void addCecBpcIpPushLock(RObjectId rObjectId) throws RException, PIHscServerException {
        this.genFspLockException(false);
        this.addCecBpcIpPushLock(rObjectId, this.mLockType, false);
    }

    public void addCecBpcIpPushLock(CIMObjectPath cIMObjectPath, int n, boolean bl) throws PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(cIMObjectPath, 14, n, bl);
    }

    public void addCecBpcIpPushLock(RObjectId rObjectId, int n, boolean bl) throws RException, PIHscServerException {
        this.genFspLockException(bl);
        this.addReqRecord(rObjectId, 14, n, bl);
    }

    public Object[] queryPALock() throws PIHscServerException {
        FspLockRecord[] fspLockRecordArray = this.mLockMgr.getAllLockRecords();
        if (fspLockRecordArray == null || fspLockRecordArray.length == 0) {
            return null;
        }
        for (int i = 0; i < fspLockRecordArray.length; ++i) {
            long[] lArray = fspLockRecordArray[i].getResIds();
            if (lArray[0] != 2L || lArray[1] != 2L) continue;
            Object[] objectArray = new Object[]{fspLockRecordArray[i].getReqId(), fspLockRecordArray[i].getHmcId()};
            System.out.println("PA fsp lock id" + objectArray[0]);
            FspLockRequest fspLockRequest = this.mLockMgr.getLockRequestByFspId(fspLockRecordArray[i].getReqId());
            if (fspLockRequest != null) {
                objectArray[0] = fspLockRequest.getLockRequestId();
                System.out.println("replaced fsp lock id with hmc id " + objectArray[0]);
            }
            return objectArray;
        }
        return null;
    }

    public Object[] queryDumpLock() throws PIHscServerException {
        FspLockRecord[] fspLockRecordArray = this.mLockMgr.getAllLockRecords();
        if (fspLockRecordArray == null || fspLockRecordArray.length == 0) {
            return null;
        }
        for (int i = 0; i < fspLockRecordArray.length; ++i) {
            long[] lArray = fspLockRecordArray[i].getResIds();
            if (lArray[0] != 2L || lArray[1] != 3L) continue;
            Object[] objectArray = new Object[]{fspLockRecordArray[i].getReqId(), fspLockRecordArray[i].getHmcId()};
            System.out.println("Dump fsp lock id" + objectArray[0]);
            FspLockRequest fspLockRequest = this.mLockMgr.getLockRequestByFspId(fspLockRecordArray[i].getReqId());
            if (fspLockRequest != null) {
                objectArray[0] = fspLockRequest.getLockRequestId();
                System.out.println("replaced fsp lock id with hmc id " + objectArray[0]);
            }
            return objectArray;
        }
        return null;
    }

    private void genFspLockException(boolean bl) throws PIHscServerException {
        if (this.mLockMgr.getSupportMultiHMC() || bl) {
            return;
        }
        throw new FspLockException("0263", null, 4, null, null);
    }
}

